-- effects
local FlipIn = {
	Init = cmd(diffusealpha,0;rotationx,-90),
	On = cmd(linear,0.75;rotationx,0;diffusealpha,1);
};
local SlideDown = {
	Init = cmd(),
	On = cmd(y,-SCREEN_HEIGHT;decelerate,1;y,SCREEN_CENTER_Y);
};
local SlideUp = {
	Init = cmd(),
	On = cmd(y,SCREEN_HEIGHT*2;decelerate,1;y,SCREEN_CENTER_Y);
};
local SlideRight = {
	Init = cmd(),
	On = cmd(x,-SCREEN_WIDTH;decelerate,1;x,SCREEN_CENTER_X);
};
-- this one was written by NAKET Coder for NCEvo; I've modified it to work better
-- with 320x240 backgrounds, but it's still not pefect yet, as it needs to match
-- how Gameplay deals with the background. -aj
local NCEvo = {
	Init = cmd(y,-SCREEN_HEIGHT;zoom,0.45);
	On = function(self)
		self:linear(0.5);
		self:y(SCREEN_CENTER_Y);
		self:rotationx(180);
		self:zoom(0.7);
		self:diffuse(color("0.5,0.5,0.5,1"));

		self:bounceend(0.9);
		self:rotationx(360); -- set the rotation to xbox 360
		self:diffuse(color("1,1,1,1"));
		self:FullScreen();
		self:sleep(0.25);
		self:accelerate(0.15);
		self:glow(1,1,1,0.8);
		self:sleep(0.1);
		self:decelerate(0.15);
		self:glow(1,1,1,0);
	end;
};
-- effects table
local effects = {
	FlipIn,
	SlideDown,
	SlideUp,
	SlideRight,
	NCEvo
};

local effectToPick = effects[math.random(#effects)];

local t = Def.ActorFrame {
	InitCommand=cmd(fov,90);
	LoadActor( THEME:GetPathB("_shared background","normal") );

	Def.ActorFrame{
		BeginCommand=function(self) self:visible(not GAMESTATE:IsCourseMode()); end;
		LoadSongBackground() .. {
			BeginCommand=effectToPick.Init;
			OnCommand=effectToPick.On;
		};
	};

	Def.Quad{
		Condition=GAMESTATE:IsCourseMode();
		InitCommand=cmd(FullScreen;diffuse,color("0,0,0,0"));
		OnCommand=cmd(linear,0.75;diffusealpha,1);
	};
};

return t;